#!%perl%

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################





$cf{fields} = {
	sitename	=> 10,
	descr		=> 10,
	keywords	=> 20,
	domain		=> 15,
	dir		=> 15,
};
$cf{se_results} = 15;

#$cf{datapath} = "/path/to/avspro";

#----------------------! do not edit below this line !-----------------------


use strict;

use vars qw(%cf %cgi %mysql %used @cats);
my (
	$inited,
	@results,
	$where,
	$db,
);

initvars();
foreach ("routines", "substapts", "http") {
	eval { require "$_.pl" };
	err("Could not include $_.pl") if $@;
}
readconf();
getcgi(
	"query",
	"cat",
	"scheme",
	"bodytag",
	"tabletag",
	"tdtag",
	"fonttag",
);

$cf{cat} = $cgi{cat};
$cf{scheme}	= $cgi{scheme}
		|| randline("schemes", qq[where cats = ""]. ($cf{cat} ? qq[ or cats = "$cf{cat}"] : ""), "name");
$cf{bodytag}	= $cgi{bodytag}
		|| randline("bodytags", qq[where scheme="$cf{scheme}"], "tag");
$cf{tabletag}	= $cgi{tabletag}
		|| randline("tabletags", qq[where scheme="$cf{scheme}"], "tag");
$cf{tdtag}	= $cgi{tdtag}
		|| randline("tdtags", qq[where scheme="$cf{scheme}"], "tag");
$cf{fonttag}	= $cgi{fonttag}
		|| randline("fonttags", qq[where scheme="$cf{scheme}" or scheme=""], "tag");


my $where = qq[id > 0];
$where .= qq[ and cat="$cgi{cat}"] if $cgi{cat};

dosearch($cgi{query});
$cf{numresults} = ($#results + 1) || 0;
$cf{catselect} = catselect($cgi{cat});

inithtml();
my $out = substapts(readfile("$cf{datapath}/templates/search/head.tmpl"));
foreach my $res (@results) {
	foreach (keys %{$res}) {
		$cf{"search$_"} = ${$res}{$_};
	}
	$cf{searchurl} = "http://$cf{searchdomain}/$cf{searchdir}/";
	$out .= substapts(readfile("$cf{datapath}/templates/search/item.tmpl"));
}
$out .= substapts(readfile("$cf{datapath}/templates/search/foot.tmpl"));
print $out;


#---------------------------------! subs !------------------------------------

sub	dosearch {
	my $query = shift;
	study $query;
	$query =~ s/[^\w .&"'+-]//g;
	my $score;
	if ($query) {
		while ($query =~ /([+-]?)/gc) {
			my $req = $1;
			$query =~ /\G(['"])(.+?)\1/gc || $query =~ /\G()([^'"\s]\S+)\b/gc || next;
			my $m = $2;
			if ($req eq "+") {
				$where .= qq[ and (].
					join(" or ", map { qq[$_ like "%$m%"] } keys %{$cf{fields}}) .
					qq[)];
			}
			elsif ($req eq "-") {
				$where .= qq[ and not (].
					join(" or ", map { qq[$_ like "%$m%"] } keys %{$cf{fields}}) .
					qq[)];
			}
			else {
				$score .= join(" + ", map { qq[(($_ like "%$m%") * ${$cf{fields}}{$_})] } keys %{$cf{fields}})
			}
		}
		$score ||= 1;
		my $ac = dosql(qq[select *,($score) as score from ap_sites where $where ].
			qq[order by score desc, ctime desc limit $cf{se_results}]);
		while (my $row = $ac->fetchrow_hashref) {
			last if $$row{score} < 1;
			push(@results, $row);
		}
	} else {
		my $ac = dosql("select count(*) from ap_sites where $where");
		my $rows = ($ac->fetchrow_array)[0];
		foreach (1..$cf{se_results}) {
			my $n = int(rand($rows));
			my $max = $n || 1;
			$ac = dosql(qq[select *,1 as score from ap_sites limit $n,$max]);
			push(@results, $ac->fetchrow_hashref) if $ac->rows;
		}
	}
}

sub	initvars {
	$cf{cgiurl} = "http://$ENV{HTTP_HOST}$ENV{SCRIPT_NAME}" if !$cf{cgiurl};
}
